import {EAffiliateQueryParams} from 'constants/affiliate/queryParams';

import {IUtmQueryParams} from 'types/common/IQueryParams';

import {isValidPartnerLink} from 'projects/partners/utilities/urls/validate';
import {purifyPartnerLink} from 'projects/partners/utilities/urls/purify';
import {prepareLink} from 'projects/partners/utilities/urls/prepareLink';

export interface IDistributionQueryParams {
    [EAffiliateQueryParams.AFFILIATE_CLID]: string;
    [EAffiliateQueryParams.AFFILIATE_VID]?: string;
}

export function getPartnersLink(
    originUrl: string,
    partnerParams: IDistributionQueryParams,
    utms?: IUtmQueryParams,
): string {
    if (!isValidPartnerLink(originUrl)) {
        throw new Error('partner link is not valid');
    }

    const parsedUrl = new URL(purifyPartnerLink(prepareLink(originUrl)));
    const searchParams = {...partnerParams, ...utms};

    Object.entries(searchParams).forEach(([key, value]) => {
        if (value) {
            parsedUrl.searchParams.append(key, value);
        }
    });

    return parsedUrl.toString();
}
