import {PARTNERS_QUERY_PARAMS} from 'constants/affiliate/queryParams';
import mapFieldToQuery from 'server/utilities/DataStorage/AttributionData/constants/mapFieldToQuery';

const PARAMS_BLACK_LIST = [
    ...Object.values(mapFieldToQuery).reduce(
        (params, item) => [...params, ...item],
        [],
    ),
    ...PARTNERS_QUERY_PARAMS,
];

export function purifyPartnerLink(link: string): string {
    const parsedUrl = new URL(link);

    PARAMS_BLACK_LIST.forEach(param => parsedUrl.searchParams.delete(param));

    return parsedUrl.toString();
}
