import {TLD} from 'constants/tld';

import {getProjectUrl} from 'utilities/url';
import {prepareLink} from 'projects/partners/utilities/urls/prepareLink';

/**
 * Фактически поддерживаемые нац версии
 */
export const ACTUAL_TLD = [TLD.RU];

export function isValidPartnerLink(link?: string): boolean {
    if (!link) {
        return false;
    }

    try {
        const {origin} = new URL(prepareLink(link));

        return ACTUAL_TLD.some(tld => getProjectUrl(tld) === origin);
    } catch (e) {
        return false;
    }
}
