import {useCallback, useEffect, useState} from 'react';

import {
    AFFILIATE_POST_MESSAGE_DATA,
    AFFILIATE_POST_MESSAGE_INIT,
} from 'projects/partners/constants/postMessage';

import {IAffiliatePartnerData} from 'projects/partners/types/IAffiliatePartnerData';

export function useAffiliatePartnerDataProvider(): Nullable<IAffiliatePartnerData> {
    const [data, setData] = useState<Nullable<IAffiliatePartnerData>>(null);
    const handleMessage = useCallback((e: MessageEvent): void => {
        if (e.data?.type === AFFILIATE_POST_MESSAGE_DATA) {
            setData(e.data.payload);
        }
    }, []);

    useEffect(() => {
        window.addEventListener('message', handleMessage, false);
        window.parent.postMessage({type: AFFILIATE_POST_MESSAGE_INIT}, '*');

        return (): void => {
            window.removeEventListener('message', handleMessage, false);
        };
    }, [handleMessage]);

    return data;
}
