import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {loadable} from 'utilities/pageLoadable';

import UnsubscribePage from 'projects/subscription/pages/Unsubscribe/Unsubscribe';

const NotFoundApp = loadable(
    () => import('components/NotFound/NotFoundPage/NotFoundPage'),
);

const SubscriptionApp: React.FC = () => {
    return (
        <Switch>
            <Route
                path={URLs.subscriptionUnsubscribe}
                component={UnsubscribePage}
            />

            <Route component={NotFoundApp} />
        </Switch>
    );
};

export default SubscriptionApp;
