import React from 'react';

import {CHAR_NBSP} from 'utilities/strings/charCodes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/trains-coronovirus';

import Card from 'components/Card/Card';
import Link from 'components/Link/Link';

import cx from './Banners.scss';

const Banners: React.FC = () => {
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            <Card
                className={cx('banner', 'banner__card')}
                shadow="default"
                x={deviceType.isMobile ? 3 : 8}
                y="5"
            >
                <Link
                    url={i18nBlock.moreDashLink()}
                    target="_blank"
                    rel="nofollow noopener noreferrer"
                >
                    {i18nBlock.more()}
                    {CHAR_NBSP}
                </Link>
                <span>{`${i18nBlock.moreDashReason()}`}</span>
            </Card>
        </div>
    );
};

export default Banners;
