import React, {useEffect, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {reachGoal} from 'utilities/metrika';
import {useMobile} from 'utilities/hooks/useMobile';

import * as i18nBlock from 'i18n/trains-error-page-common';

import LayoutError500 from 'components/Layouts/LayoutError500/LayoutError500';
import {TErrorActionType} from 'components/ErrorModal/ErrorModal';

import cx from './CommonSearchError.scss';

interface ICommonSearchErrorProps extends IWithClassName {
    onUpdate?(): void;
}

const CommonSearchError: React.FC<ICommonSearchErrorProps> = props => {
    const {onUpdate, className} = props;
    const isMobile = useMobile();

    useEffect(() => {
        reachGoal(ETrainsGoal.ERROR_PAGE_COMMON_SHOW);
    }, []);

    const action = useMemo(
        (): TErrorActionType => ({
            type: 'button',
            title: i18nBlock.actionText(),
            handler: onUpdate,
        }),
        [onUpdate],
    );

    return (
        <LayoutError500
            className={cx(className, 'root', {root_mobile: isMobile})}
            title={i18nBlock.title()}
            subtitle={i18nBlock.subtitle()}
            action={action}
        />
    );
};

export default CommonSearchError;
