import React, {useEffect} from 'react';

import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {IWithClassName} from 'types/withClassName';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {reachGoal} from 'utilities/metrika';
import getNotFoundTitle from 'projects/trains/lib/meta/searchMeta/getNotFoundTitle';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import EmptySerp from 'components/EmptySerp/EmptySerp';

interface IEmptySearchProps extends IWithClassName {
    context: ITrainsFilledSearchContext;
    sort?: ITrainsSearchSort;
    title?: React.ReactNode;
    subtitle?: React.ReactNode;
}

const EmptySearch: React.FC<IEmptySearchProps> = props => {
    const {context, sort, className} = props;
    const notFoundText = getNotFoundTitle({context, sort});
    const {title = notFoundText.title, subtitle = notFoundText.subtitle} =
        props;

    useEffect(() => {
        reachGoal(ETrainsGoal.NO_ROUTES_HINTS_PAGE_LOAD);
    }, []);

    return (
        <EmptySerp
            className={className}
            title={title}
            text={subtitle}
            withIcon
            {...prepareQaAttributes('no-trains')}
        />
    );
};

export default EmptySearch;
