import React from 'react';

import {IHintProps} from 'projects/trains/components/Hint/types';

import {useMobile} from 'utilities/hooks/useMobile';

import HintDesktop from 'projects/trains/components/Hint/components/HintDesktop/HintDesktop';
import HintMobile from 'projects/trains/components/Hint/components/HintMobile/HintMobile';

const Hint: React.FC<IHintProps> = props => {
    const isMobile = useMobile();

    if (isMobile) {
        return <HintMobile {...props} />;
    }

    return <HintDesktop {...props} />;
};

export default React.memo(Hint);
