import React from 'react';

import {EHintPosition, IHintProps} from 'projects/trains/components/Hint/types';

import cx from './HintDesktop.scss';

const HintDesktop: React.FC<IHintProps> = props => {
    const {className, text, position = EHintPosition.BOTTOM, children} = props;

    return (
        <div
            className={cx('root', className)}
            data-tooltip={text}
            data-tooltip-position={position}
        >
            {children}
        </div>
    );
};

export default React.memo(HintDesktop);
