import React from 'react';

import {IHintProps} from 'projects/trains/components/Hint/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import BottomSheet from 'components/BottomSheet/BottomSheet';

import cx from './HintMobile.scss';

type THintMobileProps = Omit<IHintProps, 'position'>;

const HintMobile: React.FC<THintMobileProps> = props => {
    const {text, children, className} = props;

    const {value: isOpened, setTrue: open, setFalse: close} = useBoolean(false);

    return (
        <div className={cx('root', className)}>
            <div className={cx('trigger')} onClick={open}>
                {children}
            </div>

            <BottomSheet isOpened={isOpened} onClose={close}>
                {text}
            </BottomSheet>
        </div>
    );
};

export default React.memo(HintMobile);
