import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {orderMessages} from 'projects/trains/lib/order/messages';
import {IStepRestriction} from 'projects/trains/lib/order/stepRestrictions/restrictions';

import TrainsRestrictionsMessage from 'projects/trains/components/Messages/TrainsRestrictionsMessage';

interface ITrainsOrderRestrictionsMessageProps extends IWithClassName {
    restrictions: IStepRestriction[];
}

const TrainsOrderRestrictionsMessage: React.FC<ITrainsOrderRestrictionsMessageProps> =
    props => {
        const {className, restrictions} = props;

        const message = useMemo(() => {
            if (restrictions.length === 0) {
                return null;
            }

            return orderMessages.get(restrictions[0]);
        }, [restrictions]);

        if (!message) {
            return null;
        }

        return (
            <TrainsRestrictionsMessage
                className={className}
                message={message}
            />
        );
    };

export default TrainsOrderRestrictionsMessage;
