import React from 'react';

import cx from './index.scss';

interface IOwnProps {
    className?: string;
    message: string;
    buttons?: React.ReactNode[];
}

type PropsType = IOwnProps;

const TrainsRestrictionsMessage: React.FC<PropsType> = props => {
    const {className, message, buttons} = props;

    return (
        <div className={cx('root', className)}>
            <p className={cx('text')}>{message}</p>

            {buttons &&
                buttons.map((button, i) => (
                    <div className={cx('button')} key={i}>
                        {button}
                    </div>
                ))}
        </div>
    );
};

export default TrainsRestrictionsMessage;
