import React from 'react';

import {IWithClassName} from 'types/withClassName';

import WarningFilledIcon from 'icons/16/WarningFilled';
import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';

import cx from './NotificationNewMobile.scss';

export interface IPassengersCountNotificationProps extends IWithClassName {
    children: React.ReactNode;
    size?: TSize;
}

const NotificationNewMobile: React.FC<IPassengersCountNotificationProps> = ({
    className,
    children,
    size = 'm',
}) => {
    if (!children) {
        return null;
    }

    return (
        <TextWithIcon
            className={className}
            size={size}
            iconLeft={WarningFilledIcon}
            iconLeftClassName={cx('icon')}
            text={children}
        />
    );
};

export default NotificationNewMobile;
