import React from 'react';
import {Moment} from 'moment-timezone';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {formatDate} from 'utilities/dateUtils';
import {HUMAN_WITH_WEEK} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/account-OrderTrains-Info';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IHeaderProps extends IWithQaAttributes {
    from: string;
    to: string;
    departureMoment: Moment;
}

const Header: React.FC<IHeaderProps> = props => {
    const {from, to, departureMoment} = props;

    const deviceType = useDeviceType();

    const departureTitle = formatDate(departureMoment, HUMAN_WITH_WEEK);

    return (
        <Flex
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
            inline={deviceType.isDesktop}
            between={deviceType.isMobile ? 1 : 2}
        >
            <Text
                size={deviceType.isMobile ? 'l' : 'xl'}
                weight="bold"
                {...prepareQaAttributes({
                    parent: props,
                    current: 'title',
                })}
            >
                {i18nBlock.title({
                    stationFrom: from,
                    stationTo: to,
                })}
            </Text>

            <Text
                size={deviceType.isMobile ? 'm' : 'xl'}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'startDate',
                })}
            >
                {departureTitle}
            </Text>
        </Flex>
    );
};

export default React.memo(Header);
