import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';

import * as i18nBlock from 'i18n/account-OrderTrains-Info';

export default function getCarTypeText(type: ETrainsCoachType): string {
    switch (type) {
        case ETrainsCoachType.SOFT:
            return i18nBlock.carTypeDotSoft();
        case ETrainsCoachType.COMMON:
            return i18nBlock.carTypeDotCommon();
        case ETrainsCoachType.COMPARTMENT:
            return i18nBlock.carTypeDotCompartment();
        case ETrainsCoachType.PLATZKARTE:
            return i18nBlock.carTypeDotPlatzkarte();
        case ETrainsCoachType.SITTING:
            return i18nBlock.carTypeDotSitting();
        case ETrainsCoachType.SUITE:
            return i18nBlock.carTypeDotSuite();
        default:
            return '';
    }
}
