import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import IPrice from 'utilities/currency/PriceInterface';

import * as i18n from 'i18n/trains-order-summary-details';

import BeddingOption from './components/BeddingOption/BeddingOption';

interface IBeddingProps extends IWithQaAttributes, IWithClassName {
    /**
     * Количество белья
     */
    count: number;
    /**
     * Цена белья за одну штуку
     */
    price: IPrice;
    /**
     * Только чтение
     */
    readOnly: boolean;
    /**
     * Белье включено в стоимость
     */
    included: boolean;
    /**
     * Белье добавлено
     */
    checked: boolean;
    onChange(checked: boolean): void;
}

const Bedding: React.FC<IBeddingProps> = props => {
    const {className, checked, included, count, price, readOnly, onChange} =
        props;

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            {included ? (
                <div
                    className={className}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'included',
                    })}
                >
                    {i18n.beddingDashIncludedDashSubtitle()}
                </div>
            ) : (
                <BeddingOption
                    readOnly={readOnly}
                    count={count}
                    price={price}
                    checked={checked}
                    onChange={onChange}
                    {...prepareQaAttributes({parent: props, current: 'option'})}
                />
            )}
        </div>
    );
};

export default Bedding;
