import {useEffect, RefObject} from 'react';
import {useInView} from 'react-intersection-observer';

interface IUseIntersectionConfirmStepObserverOptions {
    canSkipGoToAction: boolean;
    intersectionRef: RefObject<HTMLElement>;
}

export const useIntersectionConfirmStepObserver = (
    options: IUseIntersectionConfirmStepObserverOptions,
): {
    hasIntersected: boolean;
    intersectionNode?: HTMLElement | null;
} => {
    const {canSkipGoToAction, intersectionRef} = options;

    const [inViewRef, hasIntersected] = useInView({
        triggerOnce: false,
        skip: canSkipGoToAction,
    });

    const intersectionNode = intersectionRef?.current;

    useEffect(() => {
        if (intersectionNode) {
            inViewRef(intersectionNode);
        }
    }, [inViewRef, intersectionNode]);

    return {
        hasIntersected,
        intersectionNode,
    };
};
