import scrollToNode from 'utilities/dom/scrollToNode';

const BOTTOM_SHIFT = 20;

export const goToIntersectionNode = (
    intersectionNode?: HTMLElement | null,
): void => {
    if (!intersectionNode) {
        return;
    }

    const {height} = intersectionNode.getBoundingClientRect();
    const shiftY =
        height + BOTTOM_SHIFT - document.documentElement.clientHeight;

    scrollToNode(intersectionNode, {
        shiftY,
        behavior: 'smooth',
    });
};
