import React from 'react';

import IPrice from 'utilities/currency/PriceInterface';

import * as i18nBlock from 'i18n/trainsNonRefundableTariffSelector';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Price from 'components/Price/Price';

import cx from './RefundableTariffRadioLabel.scss';

interface IRefundableTariffRadioLabelProps {
    price: IPrice;
}

const RefundableTariffRadioLabel: React.FC<IRefundableTariffRadioLabelProps> =
    props => {
        const {price} = props;

        return (
            <Flex
                className={cx('label')}
                alignItems="center"
                justifyContent="space-between"
            >
                <Text size="s">{i18nBlock.refundableTariffLabel()}</Text>
                <Text size="s" weight="bold">
                    <Price value={price.value} currency={price.currency} />
                </Text>
            </Flex>
        );
    };

export default RefundableTariffRadioLabel;
