import IPrice from 'utilities/currency/PriceInterface';

import RefundableTariffRadioLabel from '../components/RefundableTariffRadioLabel/RefundableTariffRadioLabel';
import NonRefundableTariffRadioLabel from '../components/NonRefundableTariffRadioLabel/NonRefundableTariffRadioLabel';
import {IRadioboxProps} from 'components/Radiobox/controls/RadioboxPresenter';

import {ERefundableTariffRadioValue} from './radioValuesToIsNonRefundableTariff';

interface IGetOptionsParams {
    nonRefundablePlaces: number[];
    nonRefundablePrice: IPrice;
    refundablePrice: IPrice;
    discount: number;
    hasRefundablePlace: boolean;
}

export default function getOptions({
    nonRefundablePlaces,
    nonRefundablePrice,
    refundablePrice,
    discount,
    hasRefundablePlace,
}: IGetOptionsParams): IRadioboxProps['options'] {
    return [
        {
            value: ERefundableTariffRadioValue.NonRefundableTariff,
            price: nonRefundablePrice,
            places: nonRefundablePlaces,
        },
        {
            value: ERefundableTariffRadioValue.RefundableTariff,
            price: refundablePrice,
            places: undefined,
        },
    ].map(({value, price, places}) => {
        if (value === ERefundableTariffRadioValue.NonRefundableTariff) {
            return {
                value,
                label: (
                    <NonRefundableTariffRadioLabel
                        value={value}
                        price={price}
                        places={places}
                        discount={discount}
                        hasRefundablePlace={hasRefundablePlace}
                    />
                ),
            };
        }

        return {
            value,
            label: <RefundableTariffRadioLabel price={price} />,
        };
    });
}
