import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getPlaceholderText from './utilities/getPlaceholderText';

export enum EPlacesPlaceholderReason {
    REQUIREMENTS,
    NOT_SELECTED_PLACE,
}

interface IPlacesPlaceholderProps extends IWithClassName, IWithQaAttributes {
    reason: EPlacesPlaceholderReason;
}

const PlacesPlaceholder: React.FC<IPlacesPlaceholderProps> = props => {
    const {className, reason} = props;

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            {getPlaceholderText(reason)}
        </div>
    );
};

export default PlacesPlaceholder;
