import React from 'react';

import Box from 'components/Box/Box';
import Separator from 'components/Separator/Separator';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './Skeleton.scss';

const OrderSummarySkeleton: React.FC = () => {
    return (
        <Box between="5">
            <Box between="4">
                <TextSkeleton withAnimation className={cx('title')} size="m" />

                <Box className={cx('rows')} between="3">
                    <TextSkeleton withAnimation size="s" />
                    <TextSkeleton
                        className={cx('invisible')}
                        withAnimation
                        size="s"
                    />
                </Box>
            </Box>

            <Separator />

            <ButtonSkeleton withAnimation size="xl" />
        </Box>
    );
};

export default OrderSummarySkeleton;
