import {FC, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import IPrice from 'utilities/currency/PriceInterface';

import Price from 'components/Price/Price';
import {TTextSize} from 'components/Text/Text';
import StriketroughText from 'components/StriketroughText/StriketroughText';

interface ITotalPriceWithoutDiscountProps
    extends IWithClassName,
        IWithQaAttributes {
    totalPrice: IPrice;
    totalPriceWithoutDiscount?: IPrice;
    size?: TTextSize;
}

const TotalPriceWithoutDiscount: FC<ITotalPriceWithoutDiscountProps> =
    props => {
        const {
            className,
            size = 'm',
            totalPrice,
            totalPriceWithoutDiscount,
        } = props;

        const canRenderTotalPriceWithoutDiscount = useMemo(() => {
            if (!totalPriceWithoutDiscount?.value || !totalPrice?.value) {
                return false;
            }

            return totalPriceWithoutDiscount.value > totalPrice.value;
        }, [totalPriceWithoutDiscount, totalPrice]);

        if (!canRenderTotalPriceWithoutDiscount || !totalPriceWithoutDiscount) {
            return null;
        }

        return (
            <StriketroughText
                className={className}
                crossed
                theme="secondary"
                size={size}
            >
                <Price
                    color="secondary"
                    {...totalPriceWithoutDiscount}
                    {...prepareQaAttributes(props)}
                />
            </StriketroughText>
        );
    };

export default TotalPriceWithoutDiscount;
