import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EDirection} from 'types/common/EDirection';

import {setBeddingOption} from 'reducers/trains/order/actions/trains';

import beddingContainerSelector from 'projects/trains/components/OrderSummary/containers/BeddingContainer/selectors/beddingContainerSelector';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Bedding from 'projects/trains/components/OrderSummary/components/Bedding/Bedding';

interface IBeddingContainerOwnProps extends IWithClassName, IWithQaAttributes {
    direction: EDirection;
    index: number;
}

const BeddingContainer: React.FC<IBeddingContainerOwnProps> = props => {
    const {direction, index, ...rest} = props;

    const dispatch = useDispatch();
    const bedding = useSelector(beddingContainerSelector);

    const handleChange = useCallback(
        (checked: boolean): void => {
            dispatch(setBeddingOption({direction, index, data: checked}));
        },
        [dispatch, direction, index],
    );

    const currentBedding = bedding[direction][index];

    if (!currentBedding) {
        return null;
    }

    const {beddingIsVisible, ...beddingStateProps} = currentBedding;

    return <Bedding {...rest} {...beddingStateProps} onChange={handleChange} />;
};

export default BeddingContainer;
