import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import {setInsuranceIncluded} from 'reducers/trains/order/actions/userChoice';

import insuranceContainerSelector from 'projects/trains/components/OrderSummary/containers/InsuranceContainer/selectors/insuranceContainerSelector';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Insurance from 'projects/trains/components/OrderSummary/components/Insurance/Insurance';

interface IInsuranceContainerProps extends IWithClassName, IWithQaAttributes {}

const InsuranceContainer: React.FC<IInsuranceContainerProps> = props => {
    const dispatch = useDispatch();
    const {price, ...otherStateProps} = useSelector(insuranceContainerSelector);

    const handleChange = useCallback(
        (checked: boolean): void => {
            dispatch(setInsuranceIncluded(checked));
        },
        [dispatch],
    );

    if (!price) {
        return null;
    }

    return (
        <Insurance
            {...props}
            {...otherStateProps}
            price={price}
            onChange={handleChange}
        />
    );
};

export default InsuranceContainer;
