import {createSelector} from 'reselect';

import {TrainsInsuranceStatus} from 'server/api/TrainsBookingApi/types/TrainsInsuranceStatus';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';
import orderIsReservedSelector from 'selectors/trains/order/orderIsReservedSelector';
import insuranceIncludedSelector from 'selectors/trains/order/insuranceIncludedSelector';

import {getTotalInsuranceAmountByOrderInfo} from 'projects/trains/lib/order/insurance';
import IPrice from 'utilities/currency/PriceInterface';
import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

interface IInsuranceContainerSelector {
    disabled: boolean;
    price: IPrice | null;
    checked: boolean;
}

const insuranceContainerSelector = createSelector(
    [orderInfoSelector, orderIsReservedSelector, insuranceIncludedSelector],
    (orderInfo, isReserved, insuranceIncluded): IInsuranceContainerSelector => {
        const price = getTotalInsuranceAmountByOrderInfo(orderInfo);
        const insuranceStatus =
            getFirstTrainService(orderInfo)?.trainInfo?.insuranceStatus;

        return {
            disabled: insuranceStatus !== TrainsInsuranceStatus.PRICED,
            price,
            checked: insuranceIncluded,
        };
    },
);

export default insuranceContainerSelector;
