import React, {useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EDirection} from 'types/common/EDirection';

import {setNonRefundableTariff} from 'reducers/trains/order/actions/trains';

import nonRefundableTariffContainerSelector from 'projects/trains/components/OrderSummary/containers/NonRefundableTariffContainer/selectors/nonRefundableTariffContainerSelector';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import NonRefundableTariff from '../../components/NonRefundableTariff/NonRefundableTariff';

interface INonRefundableTariffContainerProps
    extends IWithClassName,
        IWithQaAttributes {
    direction: EDirection;
    index: number;
}

const NonRefundableTariffContainer: React.FC<INonRefundableTariffContainerProps> =
    props => {
        const {direction, index, ...rest} = props;

        const dispatch = useDispatch();
        const nonRefundableTariff = useSelector(
            nonRefundableTariffContainerSelector,
        );
        const currentStateProps = nonRefundableTariff[direction][index];

        const handleChange = useCallback(
            (checked: boolean): void => {
                dispatch(
                    setNonRefundableTariff({direction, index, data: checked}),
                );
            },
            [dispatch, direction, index],
        );

        if (!currentStateProps) {
            return null;
        }

        const {isVisible, ...stateProps} = currentStateProps;

        return (
            <NonRefundableTariff
                {...rest}
                {...stateProps}
                onChange={handleChange}
            />
        );
    };

export default NonRefundableTariffContainer;
