import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';
import {EDirection} from 'types/common/EDirection';

import placesContainerSelector from './selectors/placesContainerSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import PlacesItem from './components/PlacesItem/PlacesItem';

import cx from './PlacesContainer.scss';

interface IPlacesContainerProps extends IWithClassName, IWithQaAttributes {
    direction: EDirection;
    index: number;
}

const PlacesContainer: React.FC<IPlacesContainerProps> = props => {
    const {direction, index, className} = props;

    const placesState = useSelector(placesContainerSelector);
    const places = placesState[direction][index];

    return (
        <ul className={cx('root', className)} {...prepareQaAttributes(props)}>
            {places.map((placeItemStateProps, placeIndex) => (
                <PlacesItem
                    key={placeIndex}
                    className={cx('item')}
                    {...placeItemStateProps}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'placeItem',
                        key: placeIndex,
                    })}
                />
            ))}
        </ul>
    );
};

export default PlacesContainer;
