interface IPointInfo {
    settlement: string;
    station: string;
}

export interface IPointTextResult {
    from: string;
    to: string;
}

export default function getFromToText(
    from: IPointInfo,
    to: IPointInfo,
): IPointTextResult {
    const settlementsAreEquals = from.settlement === to.settlement;

    if (settlementsAreEquals) {
        return {
            from: from.station,
            to: to.station,
        };
    }

    return {
        from: from.settlement || from.station,
        to: to.settlement || to.station,
    };
}
