import {StoreInterface} from 'reducers/storeTypes';

import orderIsReservedSelector from 'selectors/trains/order/orderIsReservedSelector';
import insuranceContainerSelector from '../containers/InsuranceContainer/selectors/insuranceContainerSelector';

/**
 * Если продажа страховок отключена или по какой-то причине
 * мы не смогли получить стоимость страховки - скрываем блок
 */
export default function insuranceIsVisibleSelector(
    state: StoreInterface,
): boolean {
    const insurance = insuranceContainerSelector(state);
    const isReserved = orderIsReservedSelector(state);

    return Boolean(insurance.price?.value && isReserved);
}
