import {createStructuredSelector} from 'reselect';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import {TOrderPlaceStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';
import {StoreInterface} from 'reducers/storeTypes';

import orderPageStatusSelector from 'selectors/trains/order/orderPageStatusSelector';
import placesStepsSelector from 'selectors/trains/order/placesStepsSelector';
import totalPriceSelector, {
    ITotalPriceSelector,
} from 'selectors/trains/order/totalPriceSelector';
import trainItemContainerSelector, {
    TTrainItemContainerSelector,
} from '../containers/TrainItemContainer/selectors/trainItemContainerSelector';
import orderInfoStateSelector from 'selectors/trains/order/orderInfoStateSelector';

import totalPriceIsVisibleSelector from './totalPriceIsVisibleSelector';
import insuranceIsVisibleSelector from './insuranceIsVisibleSelector';

interface IOrderSummarySelector {
    orderPageStatus: ORDER_PAGE_STATUSES;
    placesSteps: TOrderPlaceStepDescription[];
    totalPrice: ITotalPriceSelector;
    insuranceIsVisible: boolean;
    totalPriceIsVisible: boolean;
    trainItem: TTrainItemContainerSelector;
    orderInfoState: EGenericOrderState | null;
}

const orderSummarySelector = createStructuredSelector<
    StoreInterface,
    IOrderSummarySelector
>({
    orderPageStatus: orderPageStatusSelector,
    placesSteps: placesStepsSelector,
    totalPrice: totalPriceSelector,
    insuranceIsVisible: insuranceIsVisibleSelector,
    totalPriceIsVisible: totalPriceIsVisibleSelector,
    trainItem: trainItemContainerSelector,
    orderInfoState: orderInfoStateSelector,
});

export default orderSummarySelector;
