import {createSelector} from 'reselect';
import every from 'lodash/every';

import {DIRECTIONS} from 'types/common/EDirection';

import orderPriceDetailsSelector from 'selectors/trains/order/orderPriceDetailsSelector';
import currentSegmentDirectionAndIndexSelector from 'selectors/trains/order/currentSegmentDirectionAndIndexSelector';

import compareDirectionAndIndex from 'projects/trains/lib/complexOrder/compareDirectionAndIndex';

/**
 * Если нет цены на одном из предыдущих или текущих шагов, то не показываем "Итого"
 */
const totalPriceIsVisibleSelector = createSelector(
    [orderPriceDetailsSelector, currentSegmentDirectionAndIndexSelector],
    (orderPriceDetails, current) => {
        return DIRECTIONS.every(direction => {
            const directionPriceDetails = orderPriceDetails[direction];

            return every(directionPriceDetails, (priceDetails, key) => {
                const index = Number(key);

                if (compareDirectionAndIndex({direction, index}, current) > 0) {
                    return true;
                }

                return (
                    Number.isFinite(priceDetails.price.value) &&
                    priceDetails.price.value !== 0
                );
            });
        });
    },
);

export default totalPriceIsVisibleSelector;
