import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Включено ли белье в стоимость билетов
 * @param coach выбранный вагон
 * @param isReserved заказ создан?
 */
export default function getBeddingIsIncluded(
    coach: ITrainsCoach,
    isReserved: boolean,
): boolean {
    /**
     * После создания заказа всегда показываем, что если белье есть, то оно всегда включено в стоимость
     */
    if (isReserved) {
        return true;
    }

    return !coach.canChooseBedding;
}
