import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Условие при котором показываем информацию о белье
 * @param coach выбранный вагон
 * @param beddingOption белье было выбрано
 * @param isReserved заказ создан?
 */
export function getIsShowBedding(
    coach: ITrainsCoach,
    isReserved: boolean,
    beddingOption: boolean,
): boolean {
    if (
        [TRAIN_COACH_TYPE.SITTING, TRAIN_COACH_TYPE.COMMON].includes(coach.type)
    ) {
        return false;
    }

    if (isReserved) {
        return beddingOption || !coach.canChooseBedding;
    }

    return true;
}
