import {useEffect} from 'react';
import {useDispatch} from 'react-redux';

import {cancelOrderPolling} from 'reducers/trains/order/actions/flow';

import useNetwork from 'utilities/hooks/useNetwork';

export default function useCancelOrderPollingIfNetworkGoesOffline(): void {
    const dispatch = useDispatch();
    const isNetworkOnline = useNetwork();

    useEffect(() => {
        if (!isNetworkOnline) {
            dispatch(cancelOrderPolling());
        }
    }, [dispatch, isNetworkOnline]);
}
