import {useEffect} from 'react';
import {useDispatch} from 'react-redux';

import {ITrainsSearchFormPointField} from 'projects/trains/components/SearchForm/types';

import {
    trainsFetchPriceCalendarActions,
    trainsPriceCalendarClearAction,
} from 'reducers/trains/priceCalendar/actions';

const {request: priceCalendarStartAction} = trainsFetchPriceCalendarActions;

const getFromAndToFieldSelectedKeys = ({
    fromField,
    toField,
}: {
    fromField: ITrainsSearchFormPointField;
    toField: ITrainsSearchFormPointField;
}): {
    fromFieldKey: string | null;
    toFieldKey: string | null;
} => {
    const fromSelectedValue = fromField.selectedValue;
    const toSelectedValue = toField.selectedValue;

    if (
        typeof fromSelectedValue !== 'boolean' &&
        typeof toSelectedValue !== 'boolean'
    ) {
        return {
            fromFieldKey: fromSelectedValue.pointKey,
            toFieldKey: toSelectedValue.pointKey,
        };
    }

    return {
        fromFieldKey: null,
        toFieldKey: null,
    };
};

export const useTrainsPriceCalendarProvider = ({
    fromField,
    toField,
}: {
    fromField: ITrainsSearchFormPointField;
    toField: ITrainsSearchFormPointField;
}): void => {
    const dispatch = useDispatch();
    const {fromFieldKey, toFieldKey} = getFromAndToFieldSelectedKeys({
        fromField,
        toField,
    });

    useEffect(() => {
        if (!fromFieldKey || !toFieldKey) {
            dispatch(trainsPriceCalendarClearAction());

            return;
        }

        dispatch(
            priceCalendarStartAction({
                pointFrom: fromFieldKey,
                pointTo: toFieldKey,
            }),
        );
    }, [dispatch, fromFieldKey, toFieldKey]);
};
