import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

export interface ITrainsSearchFormPointField
    extends ISuggestValue<ITrainsSuggest> {}

export type TTrainsSearchFormDateField = string | WHEN_SPECIAL_VALUE | null;

export interface ITrainsSearchFormValues {
    [ESearchFormFieldName.FROM]: ITrainsSearchFormPointField;
    [ESearchFormFieldName.TO]: ITrainsSearchFormPointField;
    [ESearchFormFieldName.START_DATE]: TTrainsSearchFormDateField;
    [ESearchFormFieldName.END_DATE]: TTrainsSearchFormDateField;
    isRoundTrip: boolean;
}

export interface ITrainsSearchFormErrors {
    [ESearchFormFieldName.FROM]?: string[];
    [ESearchFormFieldName.TO]?: string[];
    [ESearchFormFieldName.START_DATE]?: string[];
    [ESearchFormFieldName.END_DATE]?: string[];
}
