import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';

import {ITrainsPreviousSearchesStore} from 'reducers/trains/previousSearches/reducer';

export default function getPreviousFormValues(
    previousSearchesStore: ITrainsPreviousSearchesStore,
): {
    [ESearchFormFieldName.FROM]: ITrainsSuggest[];
    [ESearchFormFieldName.TO]: ITrainsSuggest[];
} {
    return {
        [ESearchFormFieldName.FROM]:
            previousSearchesStore.items?.map(previousSearch => ({
                ...previousSearch.from,
                pointKey:
                    previousSearch.from.pointKey + previousSearch.to.pointKey,
                formValuesToSet: previousSearch,
                isPreviousSearch: true,
            })) || [],
        [ESearchFormFieldName.TO]:
            previousSearchesStore.items?.map(previousSearch => ({
                ...previousSearch.to,
                pointKey:
                    previousSearch.from.pointKey + previousSearch.to.pointKey,
                formValuesToSet: previousSearch,
                isPreviousSearch: true,
            })) || [],
    };
}
