import {
    ETrainsSuggestType,
    ITrainsSuggest,
} from 'types/trains/common/ITrainsApiSuggest';

import {CHAR_MIDDLE_DOT} from 'utilities/strings/charCodes';

export default function getSuggestTitleAndDescription(item: ITrainsSuggest): {
    title: string;
    description: string;
} {
    const {
        title,
        region,
        country,
        objType,
        settlement,
        stationType,
        isUniqueTitle,
        popularTitle,
    } = item;

    if (objType === ETrainsSuggestType.SETTLEMENT) {
        const regionTitle = region && !isUniqueTitle ? `${region}, ` : '';

        return {
            title,
            description: `${regionTitle}${country}`,
        };
    }

    const regionTitle = settlement || region;
    const preparedRegionTitle = regionTitle ? `${regionTitle}, ` : '';

    return {
        title: popularTitle || title,
        description: [stationType, `${preparedRegionTitle}${country}`]
            .filter(Boolean)
            .join(` ${CHAR_MIDDLE_DOT} `),
    };
}
