import {EDirection} from 'types/common/EDirection';
import {TTrainsSegmentId} from 'types/trains/common/segment/ITrainsSegment';
import {TrainsSearchContextType} from 'reducers/trains/context/types';

export interface ITrainsPinnedSegmentIdsAndDirection {
    direction: EDirection;
    forwardSegmentId: TTrainsSegmentId;
    backwardSegmentId: TTrainsSegmentId;
}

export const getTrainsPinnedSegmentIdsAndDirectionForUrl = ({
    context,
    whenFieldValue,
    returnWhenFieldValue,
    fromFieldSlug,
    toFieldSlug,
    isRoundTripField,
}: {
    context: TrainsSearchContextType;
    fromFieldSlug: string | null;
    toFieldSlug: string | null;
    isRoundTripField: boolean;
    whenFieldValue?: string;
    returnWhenFieldValue?: string | null;
}): Partial<ITrainsPinnedSegmentIdsAndDirection> | undefined => {
    const {from, to, forwardSegmentId, when} = context;
    const isEqualWhenValues = when === whenFieldValue;
    const isEqualFromSlugs = from?.slug === fromFieldSlug;
    const isEqualToSlugs = to?.slug === toFieldSlug;

    if (
        !when ||
        !isEqualFromSlugs ||
        !isEqualToSlugs ||
        !isRoundTripField ||
        !whenFieldValue ||
        !returnWhenFieldValue ||
        !forwardSegmentId ||
        !isEqualWhenValues
    ) {
        return undefined;
    }

    return {
        forwardSegmentId,
        direction: EDirection.BACKWARD,
    };
};
