import {ReactNode} from 'react';

import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';

import {getTrainsHumanizeDatesLabel} from 'projects/trains/lib/date/getTrainsHumanizeDatesLabel';
import getSuggestTitleAndDescription from 'projects/trains/components/SearchForm/utilities/getSuggestTitleAndDescription';

import Text from 'components/Text/Text';

export default function renderSuggestItemDescription(
    item: ITrainsSuggest,
): ReactNode {
    const {formValuesToSet} = item;

    if (formValuesToSet) {
        const {startDate, endDate} = formValuesToSet;
        const searchDatesLabel = getTrainsHumanizeDatesLabel({
            startDate,
            endDate,
        });

        if (searchDatesLabel) {
            return <Text size="s">{searchDatesLabel}</Text>;
        }

        return null;
    }

    return getSuggestTitleAndDescription(item)?.description;
}
