import {ReactNode} from 'react';

import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';

import getSuggestTitleAndDescription from 'projects/trains/components/SearchForm/utilities/getSuggestTitleAndDescription';

import * as i18nCommonBlock from 'i18n/common';

import Text from 'components/Text/Text';

export default function renderSuggestItemTitle(
    item: ITrainsSuggest,
): ReactNode {
    const {formValuesToSet} = item;

    if (formValuesToSet) {
        return (
            <Text size="m" weight="medium">
                {i18nCommonBlock.direction({
                    from: formValuesToSet.from.title,
                    to: formValuesToSet.to.title,
                })}
            </Text>
        );
    }

    return getSuggestTitleAndDescription(item)?.title;
}
