import React from 'react';

import {
    isFilledTrainsSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';

import {CHAR_NBSP} from 'utilities/strings/charCodes';

import * as i18n from 'i18n/trains-UpdateNotification';

import UpdateNotification from 'projects/trains/components/UpdateNotification/UpdateNotification';
import {IUpdateNotificationProps} from 'components/UpdateNotification/UpdateNotification';

interface ISearchUpdateNotificationProps
    extends Pick<
        IUpdateNotificationProps,
        | 'onUpdate'
        | 'primaryActionText'
        | 'timeout'
        | 'text'
        | 'onShowNotification'
        | 'onSkip'
    > {
    date: string;
    context: TrainsSearchContextType;
}

const SearchUpdateNotification: React.FC<ISearchUpdateNotificationProps> = ({
    date,
    context,
    ...props
}) =>
    isFilledTrainsSearchContext(context) ? (
        <UpdateNotification
            text={i18n.textSearch({
                fromName: `${
                    context.from.popularTitle || context.from.title
                }${CHAR_NBSP}`,
                toName: `${CHAR_NBSP}${
                    context.to.popularTitle || context.to.title
                }`,
                date,
            })}
            primaryActionText={i18n.actionText()}
            {...props}
        />
    ) : null;

export default SearchUpdateNotification;
