import moment from 'moment-timezone';

import humanizeDuration from 'projects/trains/lib/date/duration/humanizeDuration';

export interface ISegment {
    departure: string;
    arrival: string;
}

/**
 * Функция возвращет длительность пересадки в удобном для человека формате.
 */
export default function getTrainsTransferHumanDuration(
    segment: ISegment,
    nextSegment: ISegment,
): string {
    const duration = moment(nextSegment.departure).diff(
        segment.arrival,
        'seconds',
    );

    return humanizeDuration(moment.duration(duration, 'seconds'));
}
