import {Meta} from '@storybook/react/types-6-0';
import moment from 'moment';

import {TStorybookFunctionComponent} from 'storybook/types';

import SegmentTimeAndStation from './SegmentTimeAndStation';

export default {
    title: 'Trains/SegmentTimeAndStation',
    component: SegmentTimeAndStation,
} as Meta;

moment.locale('ru');

const departureDate = moment('2020-01-15T15:00:00.000Z');
const arrivalDate = moment('2020-01-16T08:35:00.000Z');

const departureStation = {
    ufsTitle: null,
    codes: {express: '2030000'},
    settlementId: 54,
    title: 'Екатеринбург-Пасс.',
    country: {code: 'RU', id: 225},
    railwayTimezone: 'Europe/Moscow',
    popularTitle: 'Екатеринбург-Пасс.',
    timezone: 'Asia/Yekaterinburg',
    id: 9607404,
    settlementGeoId: 225,
    settlementTitle: 'Title',
};
const arrivalStation = {
    ufsTitle: null,
    codes: {express: '2000002'},
    settlementId: 213,
    title: 'Москва (Ярославский вокзал)',
    country: {code: 'RU', id: 225},
    railwayTimezone: 'Europe/Moscow',
    popularTitle: 'Ярославский вокзал',
    timezone: 'Europe/Moscow',
    id: 2000002,
    settlementGeoId: 213,
    settlementTitle: 'Title',
};

export const Simple: TStorybookFunctionComponent = () => (
    <SegmentTimeAndStation
        departureDate={departureDate}
        arrivalDate={arrivalDate}
        departureStation={departureStation}
        arrivalStation={arrivalStation}
    />
);
