import React, {Component} from 'react';
import {Moment} from 'moment';

import {TIME, HUMAN_SHORT} from 'utilities/dateUtils/formats';
import {
    prepareQaAttributes,
    IWithQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-segment';

import cx from './TrainSegmentTime.scss';

interface IOwnProps extends IWithQaAttributes {
    timeMoment: Moment;
    className?: string;
    dateClassName?: string;
    timeClassName?: string;
    showDate?: boolean | null;
    dateFormat?: string;
    isNextDay?: boolean;
}

export default class TrainSegmentTime extends Component<IOwnProps> {
    static defaultProps = {
        dateFormat: HUMAN_SHORT,
    };

    render(): React.ReactNode {
        const {
            showDate,
            timeMoment,
            dateFormat,
            className,
            dateClassName,
            timeClassName,
            isNextDay,
        } = this.props;

        return (
            <div className={cx('dateTime', className)}>
                {showDate && (
                    <div
                        className={cx('date', dateClassName)}
                        {...prepareQaAttributes({
                            parent: this.props,
                            current: 'date',
                        })}
                    >
                        {isNextDay
                            ? i18nBlock.nextDashDay({
                                  day: timeMoment.format(dateFormat),
                              })
                            : timeMoment.format(dateFormat)}
                    </div>
                )}

                <span
                    className={cx('time', timeClassName)}
                    {...prepareQaAttributes({
                        parent: this.props,
                        current: 'time',
                    })}
                >
                    {timeMoment.format(TIME)}
                </span>
            </div>
        );
    }
}
