import React from 'react';
import moment from 'moment-timezone';

import humanizeDuration from 'projects/trains/lib/date/duration/humanizeDuration';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './styles.scss';

interface ITrainsDurationProps extends IWithQaAttributes {
    duration: number;
    className?: string;
    prefix?: string;
    postfix?: string;
    description?: string;
}

const TrainsDuration: React.FC<ITrainsDurationProps> = props => {
    const {className, duration, postfix, prefix, description} = props;

    const durationMoment = moment.duration(duration, 'seconds');

    return (
        <div
            className={cx('duration', className)}
            {...prepareQaAttributes(props)}
        >
            {prefix && <span className={cx('prefix')}>{prefix}</span>}

            {humanizeDuration(durationMoment)}

            {description && (
                <div className={cx('durationDescription')}>{description}</div>
            )}

            {postfix && <span className={cx('postfix')}> {postfix}</span>}
        </div>
    );
};

export default TrainsDuration;
