import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nRebranding from 'i18n/index-Advantages';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import useTitle from 'components/Advantages/hooks/useTitle';
import TrainTicket3DImage from 'icons/raster-illustrations/M/TrainTicket3D';
import TicketRefund3DImage from 'icons/raster-illustrations/M/TicketRefund3D';
import Komod3DImage from 'icons/raster-illustrations/M/Komod3D';
import Support3DImage from 'icons/raster-illustrations/M/Support3D';

interface ITrainsAdvantages extends IWithClassName, IWithQaAttributes {}

const TrainsAdvantages: React.FC<ITrainsAdvantages> = props => {
    const {className} = props;

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                description: i18nRebranding.trainsAllTicketsDescription(),
                IconComponent: TrainTicket3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.trainsRefundDescription(),
                IconComponent: TicketRefund3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.commonMyTripsDescription(),
                IconComponent: Komod3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.commonSupportDescription(),
                IconComponent: Support3DImage,
                iconWidth,
                iconHeight,
            },
        ];
    }, []);

    const title = useTitle(i18nRebranding.trainsTitle);

    return (
        <Advantages
            className={className}
            title={title}
            advantages={advantages}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(TrainsAdvantages);
