import React, {Fragment} from 'react';

import {CHAR_NBSP} from 'utilities/strings/charCodes';

import {ITrainsBreadcrumbsProps} from 'projects/trains/components/TrainsBreadcrumbs';
import {ITrainsBreadcrumbsItemProps} from 'projects/trains/components/TrainsBreadcrumbs/TrainsBreadcrumbsItem';
import ArrowIcon from 'icons/16/Arrow';

import cx from './styles.scss';

const TrainsBreadcrumbsDesktop: React.FC<ITrainsBreadcrumbsProps> = props => {
    const {className, children} = props;
    const count = React.Children.count(children);

    return (
        <ol className={cx('root', className)}>
            {React.Children.map(
                children,
                (
                    child: React.ReactElement<ITrainsBreadcrumbsItemProps>,
                    index: number,
                ) => {
                    return (
                        <li className={cx('listItem')}>
                            {React.cloneElement(child, child.props)}

                            {index < count - 1 && (
                                <Fragment>
                                    {CHAR_NBSP}

                                    <ArrowIcon className={cx('arrow')} />
                                </Fragment>
                            )}
                        </li>
                    );
                },
            )}
        </ol>
    );
};

export default TrainsBreadcrumbsDesktop;
